﻿using System;
using System.Collections.Generic;
using System.Data.Linq;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    partial class REGISTRANT_DEPLOYMENT : LINQEntityBase,  IDeployment
    {
        public IDeployment Create(DoDDeploymentAdapter deployment)
        {
            REGISTRANT_DEPLOYMENT rd = new REGISTRANT_DEPLOYMENT();
            if (deployment == null)
                throw new ArgumentNullException(nameof(deployment));
            rd.STD_DEPLOYMENT_STAGE_ID = deployment.DeploymentStageId;
            rd.DUTY_PROJECT_CODE = deployment.DutyProjectCode;
            rd.STD_BRANCH_OF_SERVICE_ID = deployment.BranchOfService.Id;
            //A deploymentlocation will either have a country OR a major body of water code
            rd.DEPLOYMENT_COUNTRY = deployment.DeploymentCountry;
            rd.DEPLOYMENT_START_DATE = deployment.DeploymentStartDate;
            rd.DEPLOYMENT_END_DATE = deployment.DeploymentEndDate;
            rd.IS_ELIGIBLE_FLAG = deployment.IsEligible;
            rd.IS_GULF_WAR_VETERAN_FLAG = deployment.IsGulfWarVeteran;
            rd.STD_COMPONENT_ID = int.Parse(deployment.PersonnelCategoryCode);
            rd.USER_ENTERED_FLAG = deployment.UserEntered;
            rd.USER_VERIFIED_FLAG = deployment.UserVerified;
            rd.DEPLOYMENT_BASE = deployment.DeploymentBase;
            if (deployment.PayPlanId != 0)
            {
                rd.STD_PAYPLAN_ID = deployment.PayPlanId;
            }
            rd.LAST_UPDATED_DATE = deployment.LastUpdatedDate;
            rd.PREVIOUS_VALUES = deployment.PreviousValues;
            AddOccupations(rd, deployment.ServiceSpecificOccupation);
            return rd;
        }

        private void AddOccupations(REGISTRANT_DEPLOYMENT rd, List<ServiceSpecificOccupation> serviceSpecificOccupations)
        {
            if (serviceSpecificOccupations == null) throw new ArgumentNullException(nameof(serviceSpecificOccupations));
            foreach (var rsso in serviceSpecificOccupations)
            {
               // Console.WriteLine($"Adding Occupation to:  OccType: {rsso.Type}, Date: {rsso.StartDate}");
                rd.REGISTRANT_SERVICE_SPECIFIC_OCCUPATIONs.Add(rsso.ToRSSO());
            }
        }
    }
}
